/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen;

import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SelectionButton<T>
extends Widget {
    private final T[] values;
    private int index;
    private IClickCallback<T> clickCallback;
    private IFormatter<T> formatter = Object::toString;

    public SelectionButton(int x, int y, int width, int height, T[] values, int value) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.values = values;
        this.index = value;
        this.func_238482_a_(this.getText());
    }

    public SelectionButton(int x, int y, int width, int height, T[] values) {
        this(x, y, width, height, values, 0);
    }

    public SelectionButton<T> onClick(IClickCallback<T> callback) {
        this.clickCallback = callback;
        return this;
    }

    public SelectionButton<T> formatter(IFormatter<T> formatter) {
        this.formatter = formatter;
        return this;
    }

    public T getValue() {
        return this.values[this.index];
    }

    public void func_230982_a_(double x, double y) {
        ++this.index;
        this.index %= this.values.length;
        if (this.clickCallback != null) {
            this.clickCallback.onClick(this.getValue());
        }
        this.func_238482_a_(this.getText());
    }

    private ITextComponent getText() {
        return new StringTextComponent(this.formatter.format(this.values[this.index]));
    }

    public static interface IFormatter<T> {
        public String format(T var1);
    }

    public static interface IClickCallback<T> {
        public void onClick(T var1);
    }
}

